# **Bronx Italian American History Initiative**

[![Website screenshot][image1]](https://www.fordham.edu/academics/research/libraries-and-collections/bronx-italian-american-history-initiative/)


### **Reviewer:** Cristina Migliaccio

### **Review Date:** March 19, 2025

### **Site Link**: [https://www.fordham.edu/academics/research/libraries-and-collections/bronx-italian-american-history-initiative/](https://www.fordham.edu/academics/research/libraries-and-collections/bronx-italian-american-history-initiative/)

### **Archive Link:** [https://archive.ph/9mTbD](https://archive.ph/9mTbD)

### **Keywords:** Migration, Oral History, Italian Diaspora, Community Narratives, Public History, Digital Humanities, Memory Studies, Bronx History, Urban Ethnography, Intergenerational Narratives

### **Data Sources:**

* Oral Histories  
* [Video Interviews](https://www.library.fordham.edu/digital/browse/bronxitalian)  
* Archival Documents  
* [Family Photographs](https://biahi.ace.fordham.edu/archive-images/)  
* Transcribed Narratives  
* Institutional Records  
* [Digital Portfolio](https://biahi.ace.fordham.edu/food-for-thought/)

### **Processes:**

* The archive is a public-facing oral history project documenting the experiences of Italian Americans in the Bronx through recorded interviews and digitized historical materials.  
* Interview subjects include first-generation Italian immigrants, their descendants, and scholars specializing in Italian American studies.  
* Oral histories are recorded, transcribed, and archived in a structured database accessible through Fordham University.  
* [Narratives](https://biahi.ace.fordham.edu/interactive-map/) are geolocated by borough neighborhoods, creating a spatial representation of Italian American settlement patterns.  
* The project engages community members by encouraging families to contribute personal materials and participate in storytelling initiatives.  
* Many interviews focus on working-class and labor experiences, reflecting the socio-economic contributions of Bronx Italians.  
* The archive partners with scholars, educators, and the public to promote accessible scholarship on the Italian American experience.

### **Presentation:** 
The project is structured as an oral history archive with video interviews and transcribed narratives available through Fordham University’s digital repository. The homepage introduces the project’s goals, with clear navigation to interview collections, community contributions, and research findings. The site is well-organized but could benefit from a more interactive interface to enhance engagement.

### **Digital Tools Used:**

* Content Management System (CMS): Fordham University’s digital collections platform  
* Video Hosting: YouTube and Fordham’s internal media server  
* Transcription Services: AI-assisted and human-edited transcripts  
* Geospatial Mapping: Digital tools used to plot Italian American communities across Bronx neighborhoods  
* Keyword Indexing: Enhancing searchability by tagging interviews with themes such as labor, education, and migration

### **Languages:**

* English  
* Some interviews include Italian dialects such as Neapolitan, reflecting linguistic heritage

### **Review**

The Bronx Italian American History Initiative is a valuable digital humanities project preserving and analyzing the lived experiences of Bronx Italian Americans. As an interdisciplinary effort, it blends oral history, ethnography, and archival research to offer a rich, personal perspective on migration, community, and identity.
<br>
<br>
One of its greatest strengths is its focus on working-class narratives, providing insight into labor movements, economic struggles, and cultural preservation within the Bronx. Unlike broader Italian American archives, this project emphasizes urban migration and the distinct historical dynamics of Italian life in New York City.
<br>
<br>
The archive offers compelling intergenerational perspectives, showing how Italian American identity has evolved across different decades. However, there are some areas for improvement:

1. Searchability: While transcriptions are available, the site lacks a comprehensive keyword index that would help researchers locate relevant interviews more efficiently.  
2. Interactivity: The archive would benefit from more interactive tools like [this map from the Bronx Italian American History Initiative](https://biahi.ace.fordham.edu/interactive-map/), which captures the layered history between Italian Americans and other racial and ethnic groups. This kind of feature not only highlights shared experiences but also sheds light on tensions that emerged—especially during the civil rights era—when neighborhood dynamics started to shift.  
   The map tells a powerful story about how the urban landscape of New York changed over time and how those changes affected the people living there. It touches on white flight—how many white-skinned residents, including Italian Americans, left as racial tensions rose, leaving behind communities that became predominantly Black and Brown, often underfunded and politically marginalized.  
   Decades later, many of these same neighborhoods became targets for gentrification, starting in the 1980s and accelerating in the 2000s—a shift that brought another wave of disruption and displacement.  
   Adding more interactive tools like this—ones that extend the textured history between Italian Americans and other communities, and that show how changes to the city’s landscape shaped daily life—would really strengthen the archive. It would also open the door to stories that often go untold, like those of biracial individuals from that era, such as author and filmmaker Kym Ragusa, whose work explores growing up between cultures in these very neighborhoods.  
3. Linguistic Diversity: While some interviews retain dialects, more efforts could be made to preserve and annotate regional Italian linguistic elements, which are central to identity formation.  
4. Educational Modules: The project could expand by creating classroom-friendly resources, such as discussion guides and lesson plans for use in Italian American studies courses.

<br>
Overall, the Bronx Italian American History Initiative is a significant contribution to the field of digital humanities, migration studies, and public history. With further enhancements in searchability, interactivity, and public engagement, it has the potential to become a premier resource for understanding Italian American history in urban New York.

### **How are collaborative aspects reflected in the project, and are there elements that work particularly well?** 
The initiative fosters collaboration among academics, community elders, and students through an oral history approach that highlights diverse social and economic experiences. Its partnership with Fordham University—rooted in the Bronx and with deep ties to Italian-American students—adds credibility and academic structure. A standout feature is the [photo crowdsourcing campaign](https://biahi.ace.fordham.edu/bronx-before-bronx-now/), which invites the public to contribute personal photos and stories. This participatory element deepens the archive, making the history of Italian Americans in the Bronx more layered, inclusive, and community-driven.

### **Do you see an opportunity for collaboration that would be helpful to the project?**

* Social Media Engagement: The initiative could expand its audience by leveraging platforms like Instagram and TikTok to share short video clips of interviews, potentially reaching younger generations of Italian Americans.  
* Community Submissions: Creating a “Submit Your Story” feature where Bronx residents can upload family photos, letters, and personal narratives to enrich the collection.  
* Public History Exhibits: Partnering with local museums and cultural centers to create pop-up exhibitions featuring video testimonials and artifacts from the archive.  
* Podcast Series: Developing a podcast that shares stories from the archive, making these narratives accessible to a wider audience through an audio format.

[image1]: <data:image/png;base64,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>